<?php

//ini_set('display_errors',1);

session_start();
require_once ("../../config/Cado.php");
date_default_timezone_set('America/Lima');
require_once("../notalmacen/cNotaalmacen.php");
$oNotaalmacen = new cNotaalmacen();

require_once ("../compra/cCompra.php");
$oCompra = new cCompra();

require_once ("../venta/cVenta.php");
$oVenta = new cVenta();


require_once ("../documento/cDocumento.php");
$oDocumento= new cDocumento();

require_once ("../talonario/cTalonario.php");
$oTalonario= new cTalonario();
	
require_once("../producto/cProductomarca.php");
$oProductomarca = new cProductomarca();
	
require_once ("../producto/cCatalogo.php");
$oCatalogo = new cCatalogo();
require_once ("../stock/cStock.php");
$oStock = new cStock();
require_once("../kardex/cKardex.php");
$oKardex = new cKardex();

require_once("../formatos/formato.php");

function responder($estado=false, $mensaje='', $data=[])
{
	header('Content-Type: application/json');
	echo json_encode([
		'estado' => $estado,
		'mensaje' => $mensaje,
		'data' => $data,
		]); 
	exit;
}

if($_POST['action_notaalmacen']=="insertar")
{
	
	if(empty($_POST['cmb_alm_id']))responder(false, 'Intentelo nuevamente.');

	
	
		$dts= $oDocumento->mostrarUno(29);
		$dt = mysqli_fetch_array($dts);
		$doc_nom=$dt['tb_documento_nom'];
		$doc_abr=$dt['tb_documento_abr'];
		mysqli_free_result($dts);
				
		if($doc_abr=='T'){
		$ser = 'T00'.$_SESSION['usuario_ser'];
		}else if($doc_abr=='F'){
		$ser = 'F00'.$_SESSION['usuario_ser'];
		}else if($doc_abr=='B'){
		$ser = 'B00'.$_SESSION['usuario_ser'];
		}else if($doc_abr=='GR'){
		$ser = 'GR00'.$_SESSION['usuario_ser'];
		}else if($doc_abr=='NC'){
		$ser = 'NC00'.$_SESSION['usuario_ser'];
		}else if($doc_abr=='P'){
		$ser = 'P00'.$_SESSION['usuario_ser'];
		}else if($doc_abr=='TR'){
		$ser = 'TR00'.$_SESSION['usuario_ser'];
		}else if($doc_abr=='NA'){
		$ser = 'NA00'.$_SESSION['usuario_ser'];
		}

		$dts= $oTalonario->correlativo($_SESSION['puntoventa_id'],29,$ser);
		$dt = mysqli_fetch_array($dts);
			$tal_id=$dt['tb_talonario_id'];
			$tal_ser=$dt['tb_talonario_ser'];
			$tal_fin=$dt['tb_talonario_fin'];
			$tal_num=$dt['tb_talonario_num'];
		mysqli_free_result($dts);

		$numero=$tal_num;
		$largo=strlen($tal_fin);
		$numero=str_pad($numero,$largo, "0", STR_PAD_LEFT);
		$numdoc=$tal_ser.'-'.$numero;
	
	
	//insertamos nota almacen
	$oNotaalmacen->insertar(
		fecha_mysql($_POST['txt_notalm_fec']),
		$numdoc,
		$_POST['cmb_notalm_tip'],
		$_POST['cmb_notalmtip_id'],
		$_POST['txt_notalm_des'],
		$_POST['cmb_alm_id'],
		$_POST['hdd_usu_id'],
		$_POST['hdd_emp_id'],
		$_POST['txt_notalm_res'],
		$_POST['txt_notalm_area'],
		$_POST['txt_notalm_docrel']
	);
	
	//ultimo nota de almacen
	
		$dts=$oNotaalmacen->ultimoInsert();
		$dt = mysqli_fetch_array($dts);
		$notalm_id=$dt['id'];
		mysqli_free_result($dts);
		
	$estado='1';
		if($tal_num==$tal_fin)
		{
			$estado='2';
		}
		$numero=$tal_num+1;
		$rs3 = $oTalonario->actualizar_correlativo($tal_id, $numero, $estado);
				
		
	//registro de kardex		
	$kar_des='NOTA DE ALMACEN';
	$mod_id = 6; // nota de almacen
	$idm=$notalm_id;//id de la op(modulo compras, ventas, etc)

	//insertamos kardex
	$oKardex->insertar(			
		fecha_mysql($_POST['txt_notalm_fec']),			
		$kar_des,
		$mod_id,
		$idm,
		$_POST['hdd_usu_id'],
		$_POST['hdd_emp_id'],
		'0'
	);

	//ultimo kardex
	
		$dts=$oKardex->ultimoInsert();
		$dt = mysqli_fetch_array($dts);
		$kar_id=$dt['id'];
		mysqli_free_result($dts);
			

	foreach($_SESSION['notaalmacen_catid'] as $indice => $catid)
	{			
		$cat_id = $_SESSION['notaalmacen_catid'][$indice];
		$mar_id = $_SESSION['notaalmacen_marid'][$indice];
		
		
		$dts=$oCatalogo->mostrarUno($cat_id,$mar_id);
		$dt = mysqli_fetch_array($dts);
		$emp_fac=$dt['tb_empaque_fac'];
		$precom	=$dt['tb_productomarca_precom'];
		mysqli_free_result($dts);
		
		$can1 = $_SESSION['notaalmacen_can'][$indice];
		$pos = strpos($can1, 'F');
		
		if($pos===false){
			$can  = $can1 * $emp_fac;
		}else{
			
			$canf = 0;
			$cane = 0;
			list($cane,$canf) = explode('F',$can1);
			$can2 = 0;
			if($cane>0){
				$can2 = $cane*$emp_fac;
			}
			$can = $can2 + $canf;
		}
	
		//$can = $_SESSION['notaalmacen_can'][$indice];
		
		$preven = $_SESSION['notaalmacen_preven'][$indice];
		$fecven = date('d-m-Y');
		$prevenf = $preven / $emp_fac;
		
		
		//registro detalle de notaalmacen
		$oNotaalmacen->insertar_detalle(
			$cat_id,
			$mar_id,
			$can,
			moneda_mysql($preven),
			fecha_mysql($fecven),
			$notalm_id
		);

		
		$oProductomarca->modificar_campo2($cat_id,$mar_id,'preven',$preven);
		$oProductomarca->modificar_campo2($cat_id,$mar_id,'prevenf',$prevenf);

		//stock actual
		$alm_id=$_POST['cmb_alm_id'];
		$dts=$oStock->stock_por_presentacion($cat_id,$mar_id,$alm_id);
		$dt = mysqli_fetch_array($dts);
			$sto_id		=$dt['tb_stock_id'];
			$sto_num	=$dt['tb_stock_num'];
		mysqli_free_result($dts);
		
		
		
		// if($_POST['txt_notalm_docrel']!=""){
		
		// if($_POST['cmb_notalm_tip']==1){
		
		// $dts= $oCompra->ver_existencia($_POST['txt_notalm_docrel']);
		// $dt = mysqli_fetch_array($dts);
			// $com_id	=$dt['tb_compra_id'];
		// mysqli_free_result($dts);
		
		// $linea_importe=$preunicom*$data['cantidad'];
		// $linea_valven=$linea_importe/1.18;
		// $linea_igv=$linea_importe*(0.18)/1.18;

 		// $oCompra->insertar_detalle(
				// $cat_id,
				// $data['cantidad'],
				// $preunicom,
				// '',
				// $linea_valven,
				// $linea_igv,
				// '',
				// '',
				// '',
				// $com_id
			// );
		
		// }else if($_POST['cmb_notalm_tip']==2){
		
		// $dts= $oVenta->ver_existencia($_POST['txt_notalm_docrel']);
		// $dt = mysqli_fetch_array($dts);			
		// $ven_id=$dt['tb_venta_id'];
		// mysqli_free_result($dts);
		
		// $linea_importe=$preuniven*$data['cantidad'];
		// $linea_valven=$linea_importe/1.18;
		// $linea_igv=$linea_importe*(0.18)/1.18;
		
		// $oVenta->insertar_detalle(
				// $cat_id,
				// $cate_id,
				// $pro_nom,
				// $data['cantidad'],
				// $preuniven,
				// $tipdes,
				// $descuento_linea,
				// $preuniven,
				// $linea_valven,
				// $linea_igv,
				// $ven_id
			// );
		
		// }
	
		
	
	//}
		
		
		
		//actualizacion de stock
		if($_POST['cmb_notalm_tip']==1)
		{
			$stock_nuevo=$sto_num+$can;

			if($sto_id>0)
			{
				$oStock->modificar($sto_id,$stock_nuevo);
			}
			else
			{
				$oStock->insertar($_POST['cmb_alm_id'],$cat_id,$mar_id,$stock_nuevo);
			}
		}
		
		if($_POST['cmb_notalm_tip']==2)
		{				
			$stock_nuevo=$sto_num-$can;
			$oStock->modificar($sto_id,$stock_nuevo);
		}

		$oKardex->insertar_detalle(
			$cat_id,
			$mar_id,
			$_POST['cmb_notalm_tip'],
			$can,
			moneda_mysql($precom),
			moneda_mysql($precom),
			$kar_id,
			$alm_id
		);		
	}
	
	//unset($_SESSION['notaalmacen_car']);
	
	responder(true, 'Se registró nota de almacén Nº '.$numdoc.' correctamente.', [
		'notalm_id' => $notalm_id,
		'notalm_act' => 'imprime'
		]);

}

if($_POST['action_notaalmacen']=="editar")
{
	if(!empty($_POST['txt_notalm_fec']))
	{
		$oNotaalmacen->modificar($_POST['hdd_notalm_id'],$_POST['txt_notalm_des']);		
		$data['mensaje']= 'Se modifico correctamente.';
	}
	else
	{
		$data['mensaje']= 'Intentelo de Nuevo.';
	}
	
	echo json_encode($data);
	
}

if($_POST['action']=="eliminar")
{
	if(!empty($_POST['notalm_id']))
	{
		echo "No se puede eliminar, afecta información de productos.";
	}
	else
	{
		echo 'Intentelo nuevamente.';
	}
}
?>